<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-project-innovation-initiative
* @subpackage core
* @filesource
*//** */


/**
* DPII Input Class
*
* Extends the CodeIgniter class to allow GET, POST, SERVER, COOKIES, and request headers to run xss cleaning by default
*
* @author		Elan Jaffee
* @package direct-project-innovation-initiative
* @subpackage core
*/
class DPII_Input extends CI_Input {
	
	// --------------------------------------------------------------------

	/**
	* Fetch an item from the GET array.  Changed to set xss_clean to true by default
	*
	* @access	public
	* @param	string
	* @param	bool
	* @return	string
	*/
	function get($index = NULL, $xss_clean = TRUE)
	{
		return parent::get($index, $xss_clean);
	}

	// --------------------------------------------------------------------

	/**
	* Fetch an item from the POST array.  Changed to set xss_clean to true by default
	*
	* @access	public
	* @param	string
	* @param	bool
	* @return	string
	*/
	function post($index = NULL, $xss_clean = TRUE)
	{
		return parent::post($index, $xss_clean);
	}


	// --------------------------------------------------------------------

	/**
	* Fetch an item from either the GET array or the POST.  Changed to set xss_clean to true by default
	*
	* @access	public
	* @param	string	The index key
	* @param	bool	XSS cleaning
	* @return	string
	*/
	function get_post($index = '', $xss_clean = TRUE)
	{
		return parent::get_post($index, $xss_clean);
	}

	/**
	* Fetch an item from the COOKIE array.  Changed to set xss_clean to true by default
	*
	* @access	public
	* @param	string
	* @param	bool
	* @return	string
	*/
	function cookie($index = '', $xss_clean = TRUE)
	{
		return parent::cookie($index, $xss_clean);
	}
	
	// --------------------------------------------------------------------

	/**
	* Fetch an item from the SERVER array.  Changed to set xss_clean to true by default
	*
	* @access	public
	* @param	string
	* @param	bool
	* @return	string
	*/
	function server($index = '', $xss_clean = TRUE)
	{
		return parent::server($index, $xss_clean);
	}
	
		// --------------------------------------------------------------------

	/**
	 * Request Headers
	 *
	 * In Apache, you can simply call apache_request_headers(), however for
	 * people running other webservers the function is undefined.  Changed to set xss_clean to true by default
	 *
	 * @param	bool XSS cleaning
	 *
	 * @return array
	 */
	public function request_headers($xss_clean = TRUE)
	{
		return parent::request_headers($xss_clean);
	}
	
	/** Overrides parent to use CI's latest code (v2.2 from Github as of 8/31/2014) - includes fix for HMAC mismatch errors.  See: https://github.com/EllisLab/CodeIgniter/issues/3094 */
	function _sanitize_globals()
	{
		// It would be "wrong" to unset any of these GLOBALS.
		$protected = array('_SERVER', '_GET', '_POST', '_FILES', '_REQUEST',
							'_SESSION', '_ENV', 'GLOBALS', 'HTTP_RAW_POST_DATA',
							'system_folder', 'application_folder', 'BM', 'EXT',
							'CFG', 'URI', 'RTR', 'OUT', 'IN');

		// Unset globals for securiy.
		// This is effectively the same as register_globals = off
		foreach (array($_GET, $_POST, $_COOKIE) as $global)
		{
			if ( ! is_array($global))
			{
				if ( ! in_array($global, $protected))
				{
					global $$global;
					$$global = NULL;
				}
			}
			else
			{
				foreach ($global as $key => $val)
				{
					if ( ! in_array($key, $protected))
					{
						global $$key;
						$$key = NULL;
					}
				}
			}
		}

		// Is $_GET data allowed? If not we'll set the $_GET to an empty array
		if ($this->_allow_get_array == FALSE)
		{
			$_GET = array();
		}
		else
		{
			if (is_array($_GET) AND count($_GET) > 0)
			{
				foreach ($_GET as $key => $val)
				{
					$_GET[$this->_clean_input_keys($key)] = $this->_clean_input_data($val);
				}
			}
		}

		// Clean $_POST Data
		if (is_array($_POST) AND count($_POST) > 0)
		{
			foreach ($_POST as $key => $val)
			{
				$_POST[$this->_clean_input_keys($key)] = $this->_clean_input_data($val);
			}
		}

		// Clean $_COOKIE Data
		if (is_array($_COOKIE) AND count($_COOKIE) > 0)
		{
			// Also get rid of specially treated cookies that might be set by a server
			// or silly application, that are of no use to a CI application anyway
			// but that when present will trip our 'Disallowed Key Characters' alarm
			// http://www.ietf.org/rfc/rfc2109.txt
			// note that the key names below are single quoted strings, and are not PHP variables
			unset($_COOKIE['$Version']);
			unset($_COOKIE['$Path']);
			unset($_COOKIE['$Domain']);

			// Work-around for PHP bug #66827 (https://bugs.php.net/bug.php?id=66827)
			//
			// The session ID sanitizer doesn't check for the value type and blindly does
			// an implicit cast to string, which triggers an 'Array to string' E_NOTICE.
			$sess_cookie_name = config_item('sess_cookie_name');
			if (isset($_COOKIE[$sess_cookie_name]) && ! is_string($_COOKIE[$sess_cookie_name]))
			{
				unset($_COOKIE[$sess_cookie_name]);
			}

			foreach ($_COOKIE as $key => $val)
			{
				// _clean_input_data() has been reported to break encrypted cookies
				if ($key === $sess_cookie_name && config_item('sess_encrypt_cookie'))
				{
					continue;
				}

				$_COOKIE[$this->_clean_input_keys($key)] = $this->_clean_input_data($val);
			}
		}

		// Sanitize PHP_SELF
		$_SERVER['PHP_SELF'] = strip_tags($_SERVER['PHP_SELF']);

		// CSRF Protection check on HTTP requests
		if ($this->_enable_csrf == TRUE && ! $this->is_cli_request())
		{
			$this->security->csrf_verify();
		}

		log_message('debug', "Global POS   n  COOKIE data sanitized");
	}	
	
}